function S = chris_false_twins2(S,cellTarget)
% chris_false_twins
%
% Loads spiking data (all latencies), and finds cells that spike similarly.

% Dec 22 2014: Created
% Version 2:   Now only with cell seed, as it seems to be working better than the property-based one (which
%               is now left alone in the v1 file.
% Dec 23 2014: Tiny improvements.

if(nargin<1) % First run
    fprintf('First run: reading data from Excel\n');
    fileName = 'C:\Users\Arseny\Documents\4_Cells Classification\2014 data\Spikes data CURRENT.xlsx';
    sheetName = 'latency';
    [xlsNum,xlsStr] = xlsread(fileName, sheetName);
    S.data = xlsNum;
    S.spikeMoveCost = 0;                                    % Just some value to trigger recalculation
    S.d = [];                                               % same thing.
end
if(nargin<2)
    cellTarget = 1;                                         % Default value
end
if(~isfield(S,'id'))
    fprintf('Disassembling data\n');
    S.id        = S.data(4:end,1);
    S.boxed     = S.data(4:end,2);
    S.current   = S.data(1,4:end);
    S.spiken    = S.data(3,4:end);      % Spike number
    S.mat       = S.data(4:end,4:end);  % main set of data
end

nCell = length(S.id);

uniqueCurrents = unique(S.current);                         % Angelia's "currents injected" are wrong anyway, so let's enumerate them instead
for(q=1:length(S.current))
    sweepn(q) = find(uniqueCurrents==S.current(q));         % which current injection was it?
end

spikeMoveCost = 0.01;               % When looking for a similar spike-train. 0.01 to preserve spike-count; 0.1 to preserve timing.

if(S.spikeMoveCost ~= spikeMoveCost)
    fprintf('The moving cost has changed: recalculating...\n');
    S = rmfield(S,'d');             % If the distance matrix is obsolete
end

if(~isfield(S,'d'))                 % If not yet calculated
    d = zeros(nCell);
    for(cellTarget = 1:nCell)
        %template = S.mat(cellTarget,(sweepn==sweepToUse) & ~isnan(S.mat(cellTarget,:)));
        template = S.mat(cellTarget,~isnan(S.mat(cellTarget,:))) + sweepn(~isnan(S.mat(cellTarget,:)))*200;
        for(iCell=1:cellTarget)
            %spikeSample = S.mat(iCell,(sweepn==sweepToUse) & ~isnan(S.mat(iCell,:)));
            spikeSample = S.mat(iCell,~isnan(S.mat(iCell,:))) + sweepn(~isnan(S.mat(iCell,:)))*200;
            d(cellTarget,iCell)=spkd(template,spikeSample,spikeMoveCost);                     
        end            
        fprintf('.');
        if(mod(cellTarget,50)==0); fprintf('\n'); end;
    end
    d = d+d';               % Full distance matrix
    S.d = d;                % Save in the structure    
    S.spikeMoveCost = spikeMoveCost;    % Same it as a memory
    fprintf('Done!\n');
else
    d = S.d;    
end

% for(iCell=1:nCell)
%     friends(iCell) = sum(d(:,iCell)<2);
% end
              
mdsy = cmdscale(d);         % Multidimentional scaling
S.mdsy = mdsy(:,1:2);       % Storing for the future

% figure;
% enum(mdsy(:,1),mdsy(:,2),1:nCell);
% title('Projection of spike train similarities');

% figure; hold on; plot(mdsy(:,1),mdsy(:,2),'b.');  % Simple dots instead of numbers

if(0)                   % ------------ Subset of points defined by borders
    xb = [-6.5 4];              
    yb = [-6.5 6]; 
    subset = (mdsy(:,1)>=xb(1)) & (mdsy(:,1)<=xb(2)) & (mdsy(:,2)>=yb(1)) & (mdsy(:,2)<=yb(2));

    figure; myraster(bsxfun(@plus,S.mat(find(subset),:),sweepn*200));

    figure; hold on;
    plot(mdsy(:,1),mdsy(:,2),'g.');
    plot(mdsy(subset,1),mdsy(subset,2),'k.');
    hold off;
    % set(gca,'XScale','log');
    title('Projection of spike train similarities');
else                    % ----------------- Vicinity of one cell
    
    %cellTarget = 82;
    % Promising seeds: 15 (~2sp)

    [~,reorder] = sort(d(:,cellTarget));

    if(1)               % Selected cells only
        figure('Color','White');
        myraster(bsxfun(@plus,S.mat(reorder(1:6),:),sweepn*200),S.boxed(reorder(1:6)));
        set(gca,'YTick',1:6,'YTickLabel',reorder(1:6));
        title('Similar cells');
        fprintf('Cells similar to cell #%d (id %d):\n',cellTarget,S.id(cellTarget));
        dispf(S.id(reorder(1:6)),'%d');
        
        figure; hold on;
        plot(mdsy(reorder(7:end),1),mdsy(reorder(7:end),2),'g.');
        plot(mdsy(reorder(1:6),1),mdsy(reorder(1:6),2),'k.');
        hold off;
        % set(gca,'XScale','log');
        title('Projection of spike train similarities');        
    else                % All cells in order (full version)
        figure; hold on; 
        for(iCell=1:nCell)
            lat = S.mat(iCell,:);
            lat = lat(~isnan(lat)) + sweepn(~isnan(lat))*200;
            %position = d(cellTarget,iCell);
            position = find(reorder==iCell);
            if(iCell==cellTarget)
                plot(lat,position*ones(size(lat)),'k.');
            else
                plot(lat,position*ones(size(lat)),'g.');
            end
            title(sprintf('Raster plot for seed cell # %d',cellTarget));
        end
        hold off;
    end
end

end


function myraster(data,color)
% Builds a rasterplot.
% If color is given, colors different rasters based on color numbers

if(nargin<2)
    color = zeros(size(data,1),1);
end

hold on;
[m,n] = size(data);
for(q=1:m)
    lat = data(q,:);
    lat = lat(~isnan(lat));
    x = repmat(lat,2,1);
    y = repmat([-0.4; 0.4],1,length(lat));
    if(color(q)>0)
        plot(x,1+y+(q-1),'-','Color',[1 0 0]*0.5);
    else
        plot(x,1+y+(q-1),'k-');
    end
end
hold off;
set(gca,'XTick',[],'YLim',[0 m+1]);
end


function d=spkd(tli,tlj,cost)
%
% d=spkd(tli,tlj,cost) calculates the "spike time" distance
% (Victor & Purpura 1996) for a single cost
%
% tli: vector of spike times for first spike train
% tlj: vector of spike times for second spike train
% cost: cost per unit time to move a spike
%
%  Copyright (c) 1999 by Daniel Reich and Jonathan Victor.
%  Translated to Matlab by Daniel Reich from FORTRAN code by Jonathan Victor.
%
% http://www-users.med.cornell.edu/~jdvicto/pubalgor.html
%
nspi=length(tli);
nspj=length(tlj);

if cost==0
   d=abs(nspi-nspj);
   return
elseif cost==Inf
   d=nspi+nspj;
   return
end

scr=zeros(nspi+1,nspj+1);
%
%     INITIALIZE MARGINS WITH COST OF ADDING A SPIKE
%
scr(:,1)=(0:nspi)';
scr(1,:)=(0:nspj);
if nspi & nspj
   for i=2:nspi+1
      for j=2:nspj+1
         scr(i,j)=min([scr(i-1,j)+1 scr(i,j-1)+1 scr(i-1,j-1)+cost*abs(tli(i-1)-tlj(j-1))]);
      end
   end
end
d=scr(nspi+1,nspj+1);
end